CREATE TABLE Clientes_Temp (
	Id_Cliente_Temp INT IDENTITY(1,1) NOT NULL,
	Fecha DATETIME NOT NULL,
	Id_Tipo_Con SMALLINT,
	Id_Estado_Cliente SMALLINT,
	Id_Cliente INT,
	Id_Cliente_Ref INT,
	Razon_Social VARCHAR(100),
    Apellido VARCHAR(100),
	Nombre VARCHAR(100), 
	Sexo CHAR(1),
	Estado_Civil CHAR(1),
	Fecha_Nac DATETIME,
	Id_Tipo_Doc CHAR(3),
    Doc_Nro VARCHAR(20),
    Direccion VARCHAR(100),
	Nro INT,
    Depto VARCHAR(10),
    Cp VARCHAR(10),
    Id_Pais CHAR(3),
    Id_Provincia CHAR(3),
    Provincia_Descrip VARCHAR(200),
    Id_Localidad SMALLINT,
    Localidad_Descrip VARCHAR(200),
    Id_Nacionalidad CHAR(3),
	Email VARCHAR(300),
    telefono VARCHAR(2000),
    Tel_Movil VARCHAR(20),
	Id_Trans INT,
	Importe DECIMAL(16,2),
	Nro_Trans_Pago VARCHAR(100)
	)
GO

ALTER TABLE Clientes_Temp ADD CONSTRAINT PK_CLITMP_PorId PRIMARY KEY CLUSTERED (Id_Cliente_Temp)
GO

CREATE INDEX IX_CLITMP_PorCli ON Clientes_Temp (Id_Cliente)
GO

ALTER TABLE Clientes_Temp ADD CONSTRAINT FK_CLITMP_Clientes FOREIGN KEY (Id_Cliente)
	REFERENCES Clientes (Id_Cliente)
GO

CREATE INDEX IX_CLITMP_PorCliRef ON Clientes_Temp (Id_Cliente_Ref)
GO

ALTER TABLE Clientes_Temp ADD CONSTRAINT FK_CLITMP_Clientes_Ref FOREIGN KEY (Id_Cliente_Ref)
	REFERENCES Clientes (Id_Cliente)
GO



CREATE TABLE Clientes_Temp_Doc (
	Id_Cliente_Temp INT NOT NULL,
	Item SMALLINT NOT NULL,
	Descripcion VARCHAR(100),
	Extension VARCHAR(20),
	Documento VARBINARY(8000)
)

GO

ALTER TABLE Clientes_Temp_Doc ADD CONSTRAINT PK_CLITMPD_PorId PRIMARY KEY CLUSTERED (Id_Cliente_Temp,Item)
GO


